// Copyright 2014 Google Inc. All Rights Reserved.

#ifndef ANDROID_AUTO_PROJECTION_PROTOCOL_IGAL_VERIFICATION_VENDOR_EXTENSION_CALLBACKS_H
#define ANDROID_AUTO_PROJECTION_PROTOCOL_IGAL_VERIFICATION_VENDOR_EXTENSION_CALLBACKS_H

#include "IVendorExtensionCallbacks.h"
/**
 * This class describes the interface that every sink implementation must subclass to implement the
 * GAL verification vendor extension channel over the GAL protocol. You should look at the class
 * GalVerificationVendorExtension for more documentation.
 */
class IGalVerificationVendorExtensionCallbacks {
public:
    virtual ~IGalVerificationVendorExtensionCallbacks() { }

    /**
     * Gets called when test sensor data should be injected into the sink.
     * @param sensor A reference to a GalVerificationSetSensor protocol buffer.
     * @return STATUS_SUCCESS on success, an appropriate error otherwise.
     */
    virtual int injectSensorDataCallback(const GalVerificationSetSensor& sensor) = 0;

    /**
     * Gets called when forcing the sink to chance video focus.
     * @param videoFocus A reference to a GalVerificationVideoFocus protocol buffer.
     * @return STATUS_SUCCESS on success, an appropriate error otherwise.
     */
    virtual int setVideoFocusCallback(const GalVerificationVideoFocus& videoFocus) = 0;

    /**
     * Gets called when test input data should be injected into the sink.
     * @param input A reference to a GalVerificationInjectInput protocol buffer.
     * @return STATUS_SUCCESS on success, an appropriate error otherwise.
     */
    virtual int injectInputCallback(const GalVerificationInjectInput& input) = 0;

    /**
     * Gets called when requesting a screen capture from the head unit.
     * @param request A reference to a GalVerificationScreenCaptureRequest protocol buffer.
     * @return STATUS_SUCCESS on success, an appropriate error otherwise.
     */
    virtual int requestScreenCaptureCallback(
            const GalVerificationScreenCaptureRequest& request) = 0;

    /**
     * Gets called when requesting display information from the head unit.
     * @param request A reference to a GalVerificationDisplayInformationRequest protocol buffer.
     * @return STATUS_SUCCESS on success, an appropriate error otherwise.
     */
    virtual int requestDisplayInformationCallback(
            const GalVerificationDisplayInformationRequest& request) = 0;

    /**
     * Gets called to tell phone it has either gained or lost Audio focus.
     * @param request A reference to a GalVerificationAudioFocus protocol buffer.
     * @return STATUS_SUCCESS on success, an appropriate error otherwise.
     */
    virtual int requestAudioFocusChangeCallback(
            const GalVerificationAudioFocus& request) = 0;
};

#endif // ANDROID_AUTO_PROJECTION_PROTOCOL_IGAL_VERIFICATION_VENDOR_EXTENSION_CALLBACKS_H
